//package globalExamples;

import oracle.olapi.data.cursor.Cursor;

import oracle.olapi.data.source.CursorManagerSpecification;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.SpecifiedCursorManager;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.StringParameter;
import oracle.olapi.data.source.StringSource;

import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.NotCommittableException;

import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

/**
 * Complete code for Example 6-10, Using a Parameterized Source With a 
 * Measure Dimension, in Chapter 6, Understanding Source Objects in the
 * Oracle OLAP Developer's Guide to the  OLAP API.
 * 
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 **/
public class UsingParamSourceWithMeasDim
{
  public UsingParamSourceWithMeasDim()
  {
  }

  public void run(String[] args) 
  {
    Context10g context = new Context10g(args, false);
    
    // Get the DataProvider
    DataProvider dp = context.getDataProvider();
    
    // Get the MdmMeasure objects for unit cost and price
    MdmMeasure mdmUnitCost = context.getMdmMeasureByName("UNIT_COST");
    MdmMeasure mdmUnitPrice = context.getMdmMeasureByName("UNIT_PRICE");
    // Get the Source for the measure
    Source unitCost = mdmUnitCost.getSource();
    Source unitPrice = mdmUnitPrice.getSource();

    // Create a measure dimension
    Source measDim = dp.createListSource(new Source[] {unitCost, unitPrice});

    // Get the unique identifiers of the Source objects for the measures.
    String unitCostID = unitCost.getID();
    String unitPriceID = unitPrice.getID();

    // Create a StringParameter using one of the IDs.
    StringParameter measParam = new StringParameter(dp, unitCostID);

    // Create a parameterized Source.
    StringSource measParamSrc = dp.createParameterizedSource(measParam);

    // Get the metadata objects and the Source objects for the dimensions of 
    // the measures.
    MdmPrimaryDimension mdmProdDim = 
                               context.getMdmPrimaryDimensionByName("PRODUCT");
    MdmPrimaryDimension mdmTimeDim = 
                                  context.getMdmPrimaryDimensionByName("TIME");
    MdmLevelHierarchy mdmProdHier = (MdmLevelHierarchy)
                                           mdmProdDim.getDefaultHierarchy();    
    MdmLevelHierarchy mdmTimeHier = (MdmLevelHierarchy)
                                           mdmTimeDim.getDefaultHierarchy();
    StringSource prodHier = (StringSource) mdmProdDim.getSource();
    StringSource timeHier = (StringSource) mdmTimeHier.getSource();

    // Select elements from the hierarchies.
    Source prodSel = prodHier.selectValues(new String[]
                                                   {"PRODUCT_ROLLUP::ITEM::13",
                                                    "PRODUCT_ROLLUP::ITEM::14"});

    Source timeSel = timeHier.selectValues(new String[] 
                                                   {"CALENDAR::MONTH::58",
                                                    "CALENDAR::MONTH::59"});

    // Get the short description attributes for the dimensions and
    // get the Source objects for the attributes.
    MdmAttribute mdmProdShortDescr = 
                               mdmProdDim.getShortValueDescriptionAttribute();
    MdmAttribute mdmTimeShortDescr = 
                               mdmTimeDim.getShortValueDescriptionAttribute();
    Source prodShortDescr = mdmProdShortDescr.getSource();
    Source timeShortDescr = mdmTimeShortDescr.getSource();

    // Join the hierarchy selections to the short descriptions.
    Source prodSelShortDescr = prodShortDescr.join(prodSel);
    Source timeSelShortDescr = timeShortDescr.join(timeSel);

    // Extract the values from the measure dimension elements, and join 
    // them to the specified measure and the dimension selections.
    Source result = measDim.extract().join(measDim, measParamSrc)
                                     .join(prodSelShortDescr)
                                     .join(timeSelShortDescr);

    // Get the TransactionProvider
    TransactionProvider tp = context.getTransactionProvider();
    // Prepare and commit the current transaction
    try
    {
      tp.prepareCurrentTransaction();
    }
    catch(NotCommittableException e)
    {
      context.println("Cannot prepare the current Transaction. " +
              "Caught exception " + e + ".");
    }
    tp.commitCurrentTransaction();

    // Create a Cursor
    CursorManagerSpecification cMngrSpec = 
                 dp.createCursorManagerSpecification(result);
    SpecifiedCursorManager  spCMngr = dp.createCursorManager(cMngrSpec);
    Cursor resultsCursor = spCMngr.createCursor();

    // Display the results
    //context.displayCursor(resultsCursor);
    // Display the results with only the local value of the dimension elements
    context.displayCursor(resultsCursor, true);

    //Reset the Cursor position to 1;
     resultsCursor.setPosition(1);

     //Change the value of the parameterized Source
     measParam.setValue(unitPriceID);
    
    // Using the same Cursor, display the results again
    context.println(" ");
    context.displayCursor(resultsCursor, true);
  }
  

  public static void main(String[] args)
  {
    new UsingParamSourceWithMeasDim().run(args);
  }
}
